Describe()

FUNCTION Describe()
    DLG(TI='A simple picture viewer', Button='#Help', Button='OK')
    TIME(Textout=$Date_Time)
    EDIT(Text=$Date_Time, Repeat=2, Right=':', Del=1, Ins='-')
    $titles = $AppDataPath & '\PhotoTitles.txt'
    $SaveLoadFile=$AppDataPath & '\PhotoSetting'
    SET($allPhotosCount=0, $baseDir=' ', $Dirs='C:\ProgramData\HicEst\PhotoDirs.txt', $find=' ', $clone=' ',
        $galleryRows = 3, $galleryCols = 3, $imgSel = '*.jpg', $photo1=0, $rand=' ', $sdir=' ', $subs=0)
    FILE(DRive=drives, FileDELete=$Dirs, FileDELete=$Titles)
    ARRAY(CSV=drives, NewLine=',', Name=$drvMtx)

    FILE(Name=$SaveLoadFile, EXISTs=existing)
    IF(existing)
        IF(1 == MSG(T='Continue last session?', Icon='?', Button='YesNoCancel'))
            LOAD($SaveLoadFile, $allPhotosCount, $baseDir, $find, $galleryRows, $galleryCols, $photo1, $subs, $rand)
            $photo1 = MAX(1, $photo1 - $galleryRows * $galleryCols)
            FILE(Name=$baseDir &'\'& $imgSel, Subdirs=$subs, ListFiles=$titles, Count=$allPhotosCount)
            ShowImages()
        ENDIF
    ENDIF

    FILE(DRive=drives, FileDELete=$Dirs, FileDELete=$Titles)
    ARRAY(CSV=drives, NewLine=',', Name=$drvMtx)
    DLG(LBL='First select a drive', B=$drvMtx)
    $baseDir = $txtRC
    GetDirectory()
END

FUNCTION GetDirectory()
    Images($) = ('*.jpg', '*.jpeg', '*.png', '*.bmp', '*.gif', '*.ico', '*.wdp', '*.tiff')
    DO
        FILE(FileDELete=$Dirs, FileDELete=$Titles)  ! delete 2 files
        FILE(Dir=$baseDir, ListDirs=$Dirs, CouNT=nDirs)           ! new base dir listing
        FILE(Name=$Dirs, AppendText=$drvMtx)          ! save base dir and drives
        ARRAY(CSV=$Dirs, Name=DirMtx)

        FILE(Name=$baseDir &'\'& $imgSel, SubDirs=0, ListFiles=$Titles, Count=$allPhotosCount)
        IF($allPhotosCount == 0)
            DLG(LBL=$baseDir & '(no photos)',BG=99,X=0, B=DirMtx,  LBL='Type',Y=-99,BG=99, RADio=Images,Val=$imgSel)
            $baseDir = $txtRC
        ELSE
            parent = $baseDir
            EDIT(Text=$baseDir, M1=0, R=999, L='\', M2=-1, CoPyto=parent)
            ARRAY(CSV=$Titles, Name=TitMtx)
            DLG(TI=$allPhotosCount && 'photos found', LBL='Directory',BG=99,
                B=$baseDir, B=parent,BG=900, B=DirMtx,
                LBL='Select start photo in' && $baseDir,Y=-999,BG=99, B=TitMtx)
            answer = $txtRC
            IF( INDEX(answer, '.') > 0)
                EDIT(T=answer, M1=0, R=999, L='\', M2=-1, CoPyto=dir, M1=2, R='.', M2=-1, CoPyto=filNam, M1=1, M2=999, CoPyto=ext)
                FILE(Name=answer, GetFileDir=$baseDir)
                SORT(Sort=$titles, Column=1)
                FILE(Name=$titles, Text=filNam, FoundinRow=$photo1)
                ShowImages()
            ELSE
                $baseDir = $txtRC
            ENDIF
        ENDIF
    ENDDO
END

FUNCTION ShowImages()
    SORT(Sort=$titles, Column=1)
    DO
        galleryCount = $galleryRows * $galleryCols
        ARRAY(Name=gallery, CLeaR=1)
        DO row = 1, $galleryRows
            DO col = 1, $galleryCols
                IF($rand == ' ;')
                    photoNr = col + $galleryCols * (row - 1) + $photo1 - 1
                ELSE
                    photoNr = CEILING(RAN($allPhotosCount))
                ENDIF
                IF(photoNr <= $allPhotosCount)
                    FILE(Name=$titles, Row=photoNr, RowToText=title)
                ENDIF
                gallery(row,col) = title
            ENDDO
        ENDDO
        SAVE($SaveLoadFile, $allPhotosCount, $baseDir, $find, $galleryRows, $galleryCols, $photo1, $subs, $rand)

        title = 'OK, confirm next('   & $photo1 &   '-'   & ($photo1+galleryCount-1) &   '/'   &   $allPhotosCount &   ')'
        DLG(W=1,H=1,BG=0, SLider=$photo1,W=1/$galleryCols,BG=9,MIN=0,MAX=$allPhotosCount,Left=$photo1,SIze=galleryCount,
            B=title,Y=0,X=1, B='options', image=gallery,X=-9)

        IF($txtRC == 'options')
            IF($subs== 0) $sdir = ' ;'
            IF($subs ~ 0) $sdir = ' ;With subdirs'
            oldSubdirs = $subs
            oldFind = $find
            DLG(TItle='options',
                LBL=$allPhotosCount && 'photos in' && dir && 'with $find=' && $find,BG=90,
                B='DIRECTORIES',
                B='DRIVE',
                E=$find,SYMB,
                NE=$galleryRows,SYMB,
                NE=$galleryCols,SYMB,
                NE=$photo1,SYMB,
                CHK='Random',Val=$rand,
                CHK='With subdirs', Val=$sdir,
                B='Date/Time: set ALL image titles in directory',
                B='OK',
                LBL='Right-click on a photo opens the single-photo dialog',
                B='Exit HicEst')
            $subs = ($sdir ~ ' ;')
            IF( $txtRC == 'Date/Time: set ALL image titles in directory')
                SetDatesAndTimes()
            ELSEIF( $txtRC == 'DIRECTORIES')
                $find = ''
                FILE(Name=$titles, Row=1, RowToText=title)
                drive = SUBSTRING(title, 1, 3)
                GetDirectory()
            ELSEIF( $txtRC == 'DRIVE')
                $find = ''
                Describe()
            ELSEIF(($find > ' ') + (oldFind > ' '))
                FILE(fileDelete=$titles, Name=$baseDir & '\*' & $find & '*', SubDirs=$subs, ListFiles=$titles, Count=$allPhotosCount)
                IF($allPhotosCount <= 0)
                    MSG(T='No image titles with||' && $find && '||found in' && $baseDir)
                    FILE(Name=$baseDir & '\' & $imgSel, SubDirs=$subs, ListFiles=$titles, Count=$allPhotosCount)
                ENDIF
                $photo1 = 1
                ShowImages()
            ELSEIF( $txtRC == 'Exit HicEst')
                SYSTEM(Quit=1)
            ELSEIF($subs ~ oldSubDirs)
                $find = ''
                FILE(Name=$baseDir & '\' & $imgSel, SubDirs=$subs, ListFiles=$titles, Count=$allPhotosCount)
            ENDIF
        ELSEIF($C > 0)  ! Right mouse pressed.  $R, $C, and $TXT are system variables for row, column, text
            $path = $TXT
            FILE(Name=$path, GetFileDir=dir, GetFileName=oldName, GetFileExtension=ext)
            rotateTxts($) = ('rotR = 90° right','rotU = 180°','rotL = 90° left','rot0 = no rotation')
            temp = oldName
            DO
                newName = temp
                rotateTxt = ' '
                DLG(TItle='Change of photo title',
                    E=oldName,X=0,RO=1,SYM,W=2,
                    LBL='You may clone|parts of the|selected title', E=$clone,ReadOnly=1,BG=99,Y=0,X=1,
                    LBL='You may select|a|rotation',X=-9, LB=rotateTxts,H=1/7,Value=rotateTxt,BG=99,
                    E=newName,X=-9,SYM,W=2,
                    B='do nothing',X=-9, B='CHANGE',
                    B='Copy image to directory = PhotosCopiedOn' && $Date_Time,Y=19,X=-9,W=2)
                IF(temp > ' ')
                    IF(pastTxt > ' ') newName = temp && pastTxt
                    IF((rotateTxt > ' '))
                        EDIT(T=temp, DEL=' rotR', DEL=' rotU', DEL=' rotL', DEL=' rot0' )
                        IF(INDEX(rotateTxt, 'n') == 0) newName = temp && SUBSTRING(rotateTxt, 0, 4)
                        IF(INDEX(rotateTxt, 'n')     ) newName = temp
                        EXIT
                    ENDIF
                    IF(newName == temp) EXIT
                ENDIF
                temp = newName
            ENDDO
            newName = dir & '\' & newName & ext
            IF($TxtRC == 'CHANGE')
                FILE(Name=newName, EXISTs=existing)
                IF(existing == 0)
                    FILE(Name=$path, FileRenameTo=newName)
                    FILE(Name=$titles, Text=$path, FoundinRow=found, DELeteRow=found)
                    FILE(Name=$titles, Text=newName, TexttoRow=found)
                    SORT(Sort=$titles, Column=1)
                ELSE
                    MSG(T=newName && 'exists already')
                ENDIF
            ELSEIF(SUBSTRING($TxtRC, 1, 4) == 'Copy')
                new = $AppDataPath & '\PhotosCopiedOn' && $Date_Time
                FILE(DIR=new)
                new = new & '\' & oldName & ext
                FILE(Name=$path, FileCopyToFile=new)
            ENDIF
            $photo1 = $photo1 - galleryCount
        ENDIF
        IF($photo1 > 0) $photo1 = $photo1 + galleryCount
        $photo1 = MAX(1, MIN($allPhotosCount - galleryCount + 1, $photo1))
    ENDDO
END

FUNCTION SetDatesAndTimes()
    changed = 0
    DO img = 1, $allPhotosCount
        FILE(Name=$titles, Row=img, RowToText=$path)
        IF( INDEX($path, '\20') == 0 ) ! eg .."\2024-11-01".. or .."\20241101"..
            FILE(Name=$path, GetFileName=name, GetFileDir=dir, GetImageTime=iTime)
            TIME(Pattern='MM/DD/YYYY hh:mm', Input=iTime, Pattern='YYYY-MM-DD hh-mm-', TextOut=uTime)
            IF(uTime(1) ~ ' ')
                new = dir & '\' & uTime & name
                FILE(Name=new, EXISTs=yes)
                IF(yes == 0) FILE(Name=$path, FileRenameTo=new)
                changed = changed + (yes == 0)
            ENDIF
        ENDIF
    ENDDO
    IF(changed) ShowImages()
END

FUNCTION F2() ! get $numRC
    MSG(T=$numRC, DB='O')
END

#Help
This little script runs on HicEst.exe for Windows.

.	View photos in a gallery
.	Find photos with text in title
.	Change size of the gallery
.	Single pictures from gallery
.	zoom single pictures
.	random selection
.	include/exclude sub-folders
.	remember rotation state
.	creation date and time,
.	title your photos.

Single screen size photo:
.	Left mouse click on a gallery photo
Zoom SINGLE photo:
.	Right mouse wipe desired detail
Back to gallery:
.	Left mouse click
Rotate photo:
.	Right mouse click opens options
###




